//
//
// Fragment shader for brightening pixels in the selected areas
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform float pickedHue; 
uniform float pickedSat;
uniform float pickedV; 
  
uniform vec4 modulateColor;
uniform vec4 textureRect;
varying vec2 gUV;
// r,g,b values are from 0 to 1
// h = [0,360], s = [0,1], v = [0,1]
//		if s == 0, then h = -1 (undefined)

vec3 RGBtoHSV( float r, float g, float b )
{
	float minf, maxf, delta;
	vec3 hsv; 

	minf = min(min( r, g), b);
	maxf = max(max( r, g), b);
	hsv.z = maxf; 				// v

	delta = maxf - minf;

	if( abs(maxf) > 0.0 ) {
		hsv.y = delta/maxf;    		// s
	}
	else {
		// r = g = b = 0		// s = 0, v is undefined
		hsv.y = 0.0;  // *s = 0;
		hsv.x = -1.0;  //*h = -1;
	}
	
	if( abs(r-maxf)>0.0)
		hsv.x = ( g - b ) / delta;		// between yellow & magenta
	else if( abs(g-maxf)>0.0 )
		hsv.x = 2.0 + ( b - r ) / delta;	// between cyan & yellow
	else
		hsv.x = 4.0 + ( r - g ) / delta;	// between magenta & cyan

	hsv.x = hsv.x*60.0;			  	// degrees
	if( hsv.x < 0.0 )
		hsv.x = hsv.x+ 360.0;

	return hsv; 
}

vec3 HSVtoRGB( float h, float s, float v )
{
	int i;
	float f, p, q, t;
	vec3 rgb; 

	if( abs(s) > 0.0 ) {
		h  = h/60.0;			// sector 0 to 5
		i = int(floor(h ));
		f = h - floor(h);			// factorial part of h
		p = v * ( 1.0 - s );
		q = v * ( 1.0 - s * f );
		t = v * ( 1.0 - s * ( 1.0 - f ) );

		if ( i == 0 ) {
			rgb.r = v;
			rgb.g = t;
			rgb.b = p;
		}
		else if (i == 1) {
			rgb.r = q;
			rgb.g = v;
			rgb.b = p;
		}
		else if (i == 2 ){
			rgb.r = p;
			rgb.g = v;
			rgb.b = t;
		}
		else if (i == 3){
			rgb.r = p;
			rgb.g = q;
			rgb.b = v;
		}
		else if ( i == 4){
			rgb.r = t;
			rgb.g = p;
			rgb.b = v;
		}
		else {		
			rgb.r = v;
			rgb.g = p;
			rgb.b = q;
		}
	} 
	else {
		// achromatic (grey)
		rgb.r = v; 
		rgb.g = v; 
		rgb.b = v; 
	}
	return rgb; 

}

void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        vec3 vCoord = gl_FragCoord.xyz;
        vec4 outputColor = texture2DRect(texUnit, gUV);
        vec3 hsv; 
        
        hsv = RGBtoHSV(outputColor.r, outputColor.g, outputColor.b); 
        hsv.r = pickedHue;

        hsv.g += pickedSat*0.35;
        hsv.b += pickedV*0.25;
        
        outputColor.rgb = HSVtoRGB(hsv.r, hsv.g, hsv.b);
        gl_FragColor = modulateColor * outputColor;
        gl_FragColor.a = outputColor.a; 
    }
}

